﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DpmDB;

namespace DpmDbHelper
{
    public class XBRLCodesInDbCreator
    {
        private SQLiteConnector connector;
        private string query = @"update mDomain set DomainXBRLCode = (select  o.OwnerPrefix ||'_exp:'||d.DomainCode
                                    from mDomain d
                                        inner join mConcept c on c.ConceptID = d.ConceptID
                                        inner join mOwner o on o.OwnerID = c.OwnerID
where d.DomainID = mDomain.DomainID)
where mDomain.IsTypedDomain = 0 and mDomain.DomainCode not in ('met', 'MET', 'Met');

--
update mDomain set DomainXBRLCode = (select  o.OwnerPrefix ||'_typ:'||d.DomainCode
                                    from mDomain d
                                        inner join mConcept c on c.ConceptID = d.ConceptID
                                        inner join mOwner o on o.OwnerID = c.OwnerID
where d.DomainID = mDomain.DomainID)
where mDomain.IsTypedDomain = 1 and mDomain.DomainCode not in ('met', 'MET', 'Met');

--
update mDomain set DomainXBRLCode = 'met'
where mDomain.DomainCode in ('met', 'MET', 'Met');

--
update mDimension set DimensionXBRLCode = (select  o.OwnerPrefix ||'_dim:'||d.DimensionCode
                                    from mDimension d
                                        inner join mConcept c on c.ConceptID = d.ConceptID
                                        inner join mOwner o on o.OwnerID = c.OwnerID
where d.DimensionID = mDimension.DimensionID)
where mDimension.IsTypedDimension = 0 and mDimension.DimensionCode not in ('met', 'MET', 'Met', 'MET_HD', 'MET_MD');

--
update mDimension set DimensionXBRLCode = 'MET'
where mDimension.DimensionCode in ('met', 'MET', 'Met', 'MET_HD', 'MET_MD');

--
update mMember set MemberXBRLCode = (select o.OwnerPrefix ||'_'|| d.DomainCode ||':'||m.MemberCode
from mMember m 
    inner join mConcept c on c.ConceptID = m.ConceptID
    inner join mOwner o on o.OwnerID = c.OwnerID
    inner join mDomain d on d.DomainID = m.DomainID
    inner join mConcept dc on dc.ConceptID = d.ConceptID
    inner join mOwner do on do.OwnerID = dc.OwnerID
where m.MemberID = mmember.MemberID)
";

        public XBRLCodesInDbCreator(SQLiteConnector connector)
        {
            this.connector = connector;
        }

        public void Generate()
        {
            connector.executeNonQuery(this.query);
        }
    }
}
