﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using DpmDB;
using T4U.CRT.Generation.Model;
using AT2DPM.DAL;
using AT2DPM.DAL.ExtendedModel;
using AT2DPM.DAL.Model;

namespace T4U.CRT.Generation.RelationlaTableFactory
{
    public class PageColumnFactory : IRelationalColumnFactory
    {
        private readonly mDimension _dimension;
        private readonly HashSet<mMember> _members;
        private readonly string _colIndex;

        private PageColumn column;
        private bool _forceIsInTable = false;

        public PageColumnFactory(mDimension dimension, HashSet<mMember> members, string colIndex)
        {
            if (dimension == null)
                throw new ArgumentNullException("No dimension");
            
            this._dimension = dimension;
            this._members = members;
            this._colIndex = colIndex;
        }

        public PageColumnFactory(mDimension mDimension, HashSet<mMember> members, string colIndex, bool forceIsInTable)
        {
            this._dimension = mDimension;
            this._members = members;
            this._colIndex = colIndex;
            this._forceIsInTable = forceIsInTable;
        }

        public IRelationalColumn GetColumn()
        {
            column = new PageColumn();

            column.dimCode = getXbrlCode(_dimension);
            column.index = _colIndex;
            column.addDomCode(getXbrlCode(_dimension.mDomain), getXbrlCode(_dimension));            
            column.DataType = new DataTypeMapper().MapDataType(_dimension.mDomain.DataType);

            foreach (mMember mem in this._members.Where(x=>x!= null))
            {
                string code = getXbrlCode(mem);
                if (!string.IsNullOrEmpty(code))
                    column.memCodes.Add(code);
            }

            return column;
        }

        private string getXbrlCode(mMember mem)
        {
            if (string.IsNullOrWhiteSpace(mem.MemberXBRLCode))
                return new XBRLCodeBuilder().Build(mem.mConcept, mem.MemberCode);

            return mem.MemberXBRLCode;
        }

        private string getXbrlCode(mDimension dim)
        {
            if (string.IsNullOrWhiteSpace(dim.DimensionXBRLCode))
                return new XBRLCodeBuilder().Build(dim.mConcept, dim.DimensionCode);
            
            return dim.DimensionXBRLCode;
        }

        private string getXbrlCode(mDomain dom)
        {
            if (string.IsNullOrWhiteSpace(dom.DomainXBRLCode))
                return new XBRLCodeBuilder().Build(dom.mConcept, dom.DomainCode);

            return dom.DomainXBRLCode;
        }
    }
}
