﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using DpmDB;
using AT2DPM.DAL;
using AT2DPM.DAL.ExtendedModel;
using AT2DPM.DAL.Model;
using T4U.CRT.Generation.RelationlaTableFactory;

namespace T4U.CRT.Generation.Model
{
    /// <summary>
    /// Produces dimensional characteristics basing on 
    /// </summary>
    internal class DimCharacteristicsFactory
    {        
        internal DimCharacteristic produceDimCharacteristic(mOrdinateCategorisation ordCategorisation)
        {
            if (ordCategorisation == null)
                throw new ArgumentNullException();

            DimCharacteristic newDimChar = new DimCharacteristic
            {
                DimCode = getXbrlCode(ordCategorisation.mDimension),
                DomCode = getXbrlCode(ordCategorisation.mDimension.mDomain)
            };

            if(ordCategorisation.mMember != null && ordCategorisation.mMember.MemberID != ProcesorGlobals.TypedMemberId)         
                newDimChar.MemCodes.Add(getXbrlCode(ordCategorisation.mMember));            

            return newDimChar;
        }

        private string getXbrlCode(mMember mMember)
        {
            if (string.IsNullOrWhiteSpace(mMember.MemberXBRLCode))
                return new XBRLCodeBuilder().Build(mMember.mConcept, mMember.MemberCode);

            return mMember.MemberXBRLCode;
        }

        private string getXbrlCode(mDimension mDimension)
        {
            if (string.IsNullOrWhiteSpace(mDimension.DimensionXBRLCode))
                return new XBRLCodeBuilder().Build(mDimension.mConcept, mDimension.DimensionCode);

            return mDimension.DimensionXBRLCode;
        }

        private string getXbrlCode(mDomain mDomain)
        {
            if (string.IsNullOrWhiteSpace(mDomain.DomainXBRLCode))
                return new XBRLCodeBuilder().Build(mDomain.mConcept, mDomain.DomainCode);

            return mDomain.DomainXBRLCode;
        }

        internal DimCharacteristic produceDimCharacteristic(mDimension dim, mMember mem)
        {
            if(dim == null || mem == null || string.IsNullOrEmpty(dim.DimensionXBRLCode)
                || string.IsNullOrEmpty(mem.MemberXBRLCode) || string.IsNullOrEmpty(dim.mDomain.DomainXBRLCode))
                throw new ArgumentException();

            DimCharacteristic newDc = new DimCharacteristic();
            newDc.DimCode = dim.DimensionXBRLCode;
            newDc.DomCode = dim.mDomain.DomainXBRLCode;
            newDc.MemCodes.Add(mem.MemberXBRLCode);

            return newDc;
        }
    }
}
