﻿using T4U.CRT.Generation.Model;

namespace T4U.CRT.Generation.RelationlaTableFactory
{
    public class DataTypeMapper
    {
        private string datatype;

        public IRelationColumnDataType MapDataType(string dataTypeString)
        {
            if (string.IsNullOrWhiteSpace(dataTypeString))
                return IRelationColumnDataType.String;

            switch (dataTypeString.Trim().ToLower())
            {
                case "monetary":
                    return IRelationColumnDataType.Monetary;
                case "string":
                    return IRelationColumnDataType.String;
                case "percent":
                    return IRelationColumnDataType.Percentage;
                case "percentage":
                    return IRelationColumnDataType.Percentage;
                case "boolean":
                    return IRelationColumnDataType.Boolean;
                case "date":
                    return IRelationColumnDataType.Date;
                case "integer":
                    return IRelationColumnDataType.Integer;
                case "percentage/decimal":
                    return IRelationColumnDataType.Percentage;
                case "decimal":
                    return IRelationColumnDataType.Decimal;
                case "domainbased":
                    return IRelationColumnDataType.Enumeration;
                case "text":
                    return IRelationColumnDataType.String;
                case "enumeration":
                    return IRelationColumnDataType.Enumeration;
                case "code":
                    return IRelationColumnDataType.Enumeration;
                case "enumeration/code":
                    return IRelationColumnDataType.Enumeration;
                case "true":
                    return IRelationColumnDataType.Boolean;
                case "uri":
                    return IRelationColumnDataType.String;
            }

            return IRelationColumnDataType.String;
        }
    }
}