from lxml import etree as tr
import os.path
import fileinput

p = "C:/EIOPA/2.8.0 Final/SII/eiopa.europa.eu/eu/xbrl/s2md/fws/solvency/solvency2/2023-07-15/tab/"

ns = {"label": "http://xbrl.org/2008/label"}
for pth, sdirs, fls in os.walk(p):
    for f in fls:    
        if f.endswith('lab-en.xml'):
            fc = tr.parse(os.path.join(pth,f))
            for l in fc.xpath("//label:label", namespaces = ns):
                if 's2md_t' in l.attrib['{http://www.w3.org/1999/xlink}label']:
                    tablecode = l.attrib['{http://www.w3.org/1999/xlink}label'].replace('label_s2md_t','')
                    tablelabel = l.text.replace('&','&amp;')
            fn = os.path.join(pth.replace('\\','/') + '/' + f)
            verboselabelexists = 'no'
            for linenum, line in enumerate(fileinput.input(fn, inplace = True, encoding="utf-8")):
                if 'verboseLabel' in line:
                    verboselabelexists = 'yes'
                if '</gen:link>' not in line:
                    print(line.rstrip())
                else:
                    print('<label:label xlink:type="resource" xlink:label="label_s2md_t{0}_1" xml:lang="en" xlink:role="http://www.xbrl.org/2008/role/verboseLabel">{0} {1}</label:label>'.format(tablecode,tablelabel))
                    print('<gen:arc xlink:type="arc" xlink:arcrole="http://xbrl.org/arcrole/2008/element-label" xlink:from="loc_s2md_t{0}" xlink:to="label_s2md_t{0}_1" />'.format(tablecode))
                    print('</gen:link>')
                    if verboselabelexists == 'no':
                        print('<link:roleRef roleURI="http://www.xbrl.org/2008/role/verboseLabel" xlink:type="simple" xlink:href="http://www.xbrl.org/2008/generic-label.xsd#verbose-label" />')
   